/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Locale;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

public class CommanderReplacementEffect
extends ReplacementEffectImpl {
    private final UUID commanderId;
    private final boolean alsoHand;
    private final boolean alsoLibrary;
    private final boolean forceToMove;
    private final String commanderTypeName;

    public CommanderReplacementEffect(UUID commanderId, boolean alsoHand, boolean alsoLibrary, boolean forceToMove, String commanderTypeName) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        String mayStr = forceToMove ? " " : " may ";
        this.staticText = "If a " + commanderTypeName + " would be put into its owner's graveyard from anywhere, that player" + mayStr + "put it into the command zone instead. If a " + commanderTypeName + " would be put into the exile zone from anywhere, its owner" + mayStr + "put it into the command zone instead.";
        this.commanderId = commanderId;
        this.duration = Duration.EndOfGame;
        this.alsoHand = alsoHand;
        this.alsoLibrary = alsoLibrary;
        this.forceToMove = forceToMove;
        this.commanderTypeName = commanderTypeName;
    }

    protected CommanderReplacementEffect(CommanderReplacementEffect effect) {
        super(effect);
        this.commanderId = effect.commanderId;
        this.alsoHand = effect.alsoHand;
        this.alsoLibrary = effect.alsoLibrary;
        this.forceToMove = effect.forceToMove;
        this.commanderTypeName = effect.commanderTypeName;
    }

    @Override
    public CommanderReplacementEffect copy() {
        return new CommanderReplacementEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.commanderId == null) {
            throw new IllegalArgumentException("commanderId has to be set");
        }
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.commanderId.equals(event.getTargetId())) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone().equals((Object)Zone.HAND) && !this.alsoHand) {
            return false;
        }
        if (zEvent.getToZone().equals((Object)Zone.LIBRARY) && !this.alsoLibrary) {
            return false;
        }
        switch (zEvent.getToZone()) {
            case LIBRARY: 
            case HAND: {
                return true;
            }
        }
        if (this.forceToMove) {
            switch (zEvent.getToZone()) {
                case BATTLEFIELD: 
                case GRAVEYARD: 
                case EXILED: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        String originToZone = zEvent.getToZone().toString().toLowerCase(Locale.ENGLISH);
        if (zEvent.getFromZone() == Zone.BATTLEFIELD) {
            Player player;
            Permanent permanent = zEvent.getTarget();
            if (permanent != null && (player = game.getPlayer(permanent.getOwnerId())) != null && (this.forceToMove || player.chooseUse(Outcome.Benefit, "Move " + permanent.getLogName() + " to command zone instead of your " + originToZone + "?", source, game))) {
                zEvent.setToZone(Zone.COMMAND);
                if (!game.isSimulation()) {
                    game.informPlayers(player.getLogName() + " has moved " + permanent.getLogName() + " to the command zone instead of their " + originToZone);
                }
            }
        } else {
            Player player;
            Spell spell;
            Card card = null;
            if (zEvent.getFromZone() == Zone.STACK && (spell = game.getStack().getSpell(event.getTargetId())) != null) {
                card = game.getCard(spell.getSourceId());
            }
            if (card == null) {
                card = game.getCard(event.getTargetId());
            }
            if (card != null && (player = game.getPlayer(card.getOwnerId())) != null && (this.forceToMove || player.chooseUse(Outcome.Benefit, "Move " + card.getLogName() + " to command zone instead of your " + originToZone + "?", source, game))) {
                ((ZoneChangeEvent)event).setToZone(Zone.COMMAND);
                if (!game.isSimulation()) {
                    game.informPlayers(player.getLogName() + " has moved " + card.getLogName() + " to the command zone instead of their " + originToZone);
                }
            }
        }
        return false;
    }
}

