/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Iterator;
import java.util.Locale;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class GainAbilityAllEffect
extends ContinuousEffectImpl {
    protected Ability ability;
    protected boolean excludeSource;
    protected FilterPermanent filter;
    protected boolean forceQuotes = false;

    public GainAbilityAllEffect(Ability ability, Duration duration, FilterPermanent filter) {
        this(ability, duration, filter, false);
    }

    public GainAbilityAllEffect(Ability ability, Duration duration, FilterPermanent filter, String text) {
        this(ability, duration, filter, false);
        this.staticText = text;
    }

    public GainAbilityAllEffect(Ability ability, Duration duration, FilterPermanent filter, boolean excludeSource) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability.copy();
        this.ability.newId();
        this.filter = filter;
        this.excludeSource = excludeSource;
        this.generateGainAbilityDependencies(ability, (Filter)filter);
    }

    protected GainAbilityAllEffect(GainAbilityAllEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.ability.newId();
        this.filter = effect.filter.copy();
        this.excludeSource = effect.excludeSource;
        this.forceQuotes = effect.forceQuotes;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.setRuntimeData(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (this.excludeSource && perm.getId().equals(source.getSourceId()) || !this.selectedByRuntimeData(perm, source, game)) continue;
                this.affectedObjectList.add(new MageObjectReference(perm, game));
            }
        }
    }

    @Override
    public GainAbilityAllEffect copy() {
        return new GainAbilityAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.getAffectedObjectsSet()) {
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                Permanent permanent = ((MageObjectReference)it.next()).getPermanentOrLKIBattlefield(game);
                if (permanent != null) {
                    permanent.addAbility(this.ability, source.getSourceId(), game);
                    continue;
                }
                it.remove();
                if (!this.affectedObjectList.isEmpty()) continue;
                this.discard();
            }
        } else {
            this.setRuntimeData(source, game);
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (this.excludeSource && perm.getId().equals(source.getSourceId()) || !this.selectedByRuntimeData(perm, source, game)) continue;
                perm.addAbility(this.ability, source.getSourceId(), game);
            }
        }
        return true;
    }

    protected void setRuntimeData(Ability source, Game game) {
    }

    protected boolean selectedByRuntimeData(Permanent permanent, Ability source, Game game) {
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        boolean quotes = this.forceQuotes || this.ability instanceof SimpleActivatedAbility || this.ability instanceof ActivatedManaAbilityImpl || this.ability instanceof TriggeredAbility;
        boolean each = this.filter.getMessage().toLowerCase(Locale.ENGLISH).startsWith("each");
        if (this.excludeSource && !each) {
            sb.append("other ");
        }
        sb.append(this.filter.getMessage());
        if (this.duration == Duration.WhileOnBattlefield) {
            sb.append(each ? " has " : " have ");
        } else {
            sb.append(each ? " gains " : " gain ");
        }
        if (quotes) {
            sb.append('\"');
            sb.append(CardUtil.getTextWithFirstCharUpperCase(this.ability.getRule()));
            sb.append('\"');
        } else {
            sb.append(CardUtil.stripReminderText(this.ability.getRule()));
        }
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ').append(this.duration.toString());
        }
        return sb.toString();
    }

    public GainAbilityAllEffect withForceQuotes() {
        this.forceQuotes = true;
        return this;
    }
}

