/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Iterator;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.CompoundAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class GainAbilityControlledEffect
extends ContinuousEffectImpl {
    protected CompoundAbility ability;
    protected boolean excludeSource;
    protected FilterPermanent filter;
    protected boolean forceQuotes = false;
    protected boolean durationRuleAtStart = false;

    public GainAbilityControlledEffect(Ability ability, Duration duration, FilterPermanent filter) {
        this(ability, duration, filter, false);
    }

    public GainAbilityControlledEffect(CompoundAbility ability, Duration duration, FilterPermanent filter) {
        this(ability, duration, filter, false);
    }

    public GainAbilityControlledEffect(Ability ability, Duration duration, FilterPermanent filter, boolean excludeSource) {
        this(new CompoundAbility(ability), duration, filter, excludeSource);
    }

    public GainAbilityControlledEffect(CompoundAbility ability, Duration duration, FilterPermanent filter, boolean excludeSource) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.filter = filter;
        this.excludeSource = excludeSource;
        this.setText();
        this.generateGainAbilityDependencies(ability, (Filter)filter);
    }

    protected GainAbilityControlledEffect(GainAbilityControlledEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.filter = effect.filter.copy();
        this.excludeSource = effect.excludeSource;
        this.forceQuotes = effect.forceQuotes;
        this.durationRuleAtStart = effect.durationRuleAtStart;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!perm.isControlledBy(source.getControllerId()) || this.excludeSource && perm.getId().equals(source.getSourceId())) continue;
                this.affectedObjectList.add(new MageObjectReference(perm, game));
            }
        }
    }

    @Override
    public GainAbilityControlledEffect copy() {
        return new GainAbilityControlledEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.getAffectedObjectsSet()) {
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                Permanent perm = ((MageObjectReference)it.next()).getPermanentOrLKIBattlefield(game);
                if (perm != null) {
                    for (Ability abilityToAdd : this.ability) {
                        perm.addAbility(abilityToAdd, source.getSourceId(), game);
                    }
                    continue;
                }
                it.remove();
                if (!this.affectedObjectList.isEmpty()) continue;
                this.discard();
            }
        } else {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!perm.isControlledBy(source.getControllerId()) || this.excludeSource && perm.getId().equals(source.getSourceId())) continue;
                for (Ability abilityToAdd : this.ability) {
                    perm.addAbility(abilityToAdd, source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public void setAbility(Ability ability) {
        this.ability = new CompoundAbility(ability);
    }

    public Ability getFirstAbility() {
        return (Ability)this.ability.get(0);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        if (this.durationRuleAtStart && !this.duration.toString().isEmpty() && this.duration != Duration.EndOfGame) {
            sb.append(this.duration.toString()).append(", ");
        }
        if (this.excludeSource) {
            sb.append("other ");
        }
        String gainedAbility = CardUtil.stripReminderText(this.ability.getRule());
        sb.append(this.filter.getMessage());
        if (!this.filter.getMessage().contains("you control")) {
            sb.append(" you control");
        }
        boolean singular = this.filter.getMessage().toLowerCase().startsWith("each");
        if (this.duration == Duration.WhileOnBattlefield || this.duration == Duration.EndOfGame) {
            sb.append(singular ? " has " : " have ");
        } else {
            sb.append(singular ? " gains " : " gain ");
        }
        gainedAbility = this.forceQuotes || gainedAbility.startsWith("When") || gainedAbility.startsWith("{T}") ? '\"' + gainedAbility + '\"' : CardUtil.getTextWithFirstCharLowerCase(gainedAbility);
        sb.append(gainedAbility);
        if (!this.durationRuleAtStart && !this.duration.toString().isEmpty() && this.duration != Duration.EndOfGame) {
            sb.append(' ').append(this.duration.toString());
        }
        this.staticText = sb.toString();
    }

    public GainAbilityControlledEffect withForceQuotes() {
        this.forceQuotes = true;
        this.setText();
        return this;
    }

    public GainAbilityControlledEffect withDurationRuleAtStart(boolean durationRuleAtStart) {
        this.durationRuleAtStart = durationRuleAtStart;
        this.setText();
        return this;
    }
}

