/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.LinkedEffectIdStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class GainAbilityTargetEffect
extends ContinuousEffectImpl {
    protected final Ability ability;
    private final boolean useOnCard;
    private boolean waitingCardPermanent = false;

    public GainAbilityTargetEffect(Ability ability) {
        this(ability, Duration.EndOfTurn);
    }

    public GainAbilityTargetEffect(Ability ability, Duration duration) {
        this(ability, duration, null);
    }

    public GainAbilityTargetEffect(Ability ability, Duration duration, String rule) {
        this(ability, duration, rule, false);
    }

    public GainAbilityTargetEffect(Ability ability, Duration duration, String rule, boolean useOnCard) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, ability.getEffects().getOutcome(ability, Outcome.AddAbility));
        this.ability = this.copyAbility(ability);
        this.staticText = rule;
        this.useOnCard = useOnCard;
        this.generateGainAbilityDependencies(ability, null);
    }

    protected GainAbilityTargetEffect(GainAbilityTargetEffect effect) {
        super(effect);
        this.ability = this.copyAbility(effect.ability);
        this.useOnCard = effect.useOnCard;
        this.waitingCardPermanent = effect.waitingCardPermanent;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            this.getTargetPointer().getTargets(game, source).stream().map(game::getPermanent).filter(Objects::nonNull).forEach(permanent -> this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game)));
            if (this.useOnCard) {
                this.getTargetPointer().getTargets(game, source).stream().map(game::getCard).filter(Objects::nonNull).forEach(card -> this.affectedObjectList.add(new MageObjectReference((MageObject)card, game)));
                this.waitingCardPermanent = true;
                if (this.affectedObjectList.size() > 1) {
                    throw new IllegalArgumentException("Gain ability can't target a multiple cards (unsupported)");
                }
            }
        }
    }

    @Override
    public GainAbilityTargetEffect copy() {
        return new GainAbilityTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        if (this.getAffectedObjectsSet()) {
            ArrayList<MageObjectReference> newWaitingPermanents = new ArrayList<MageObjectReference>();
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                MageObjectReference mor = (MageObjectReference)it.next();
                Permanent permanent = mor.getPermanent(game);
                if (permanent != null) {
                    this.waitingCardPermanent = false;
                    permanent.addAbility(this.ability, source.getSourceId(), game);
                    ++affectedTargets;
                    continue;
                }
                if (this.useOnCard) {
                    Card card = mor.getCard(game);
                    if (card != null) {
                        game.getState().addOtherAbility(card, this.ability);
                        ++affectedTargets;
                        continue;
                    }
                    Permanent perm = game.getPermanent(mor.getSourceId());
                    if (perm != null) {
                        perm.addAbility(this.ability, source.getSourceId(), game);
                        ++affectedTargets;
                        newWaitingPermanents.add(new MageObjectReference(perm, game));
                        this.waitingCardPermanent = false;
                    }
                }
                it.remove();
            }
            if (!newWaitingPermanents.isEmpty()) {
                this.affectedObjectList.addAll(newWaitingPermanents);
                return affectedTargets > 0;
            }
            if (this.affectedObjectList.isEmpty()) {
                this.discard();
            }
            if (this.duration == Duration.Custom && affectedTargets == 0 && !this.waitingCardPermanent) {
                this.discard();
            }
        } else {
            for (UUID objectId : this.getTargetPointer().getTargets(game, source)) {
                Card card;
                Permanent permanent = game.getPermanent(objectId);
                if (permanent != null) {
                    permanent.addAbility(this.ability, source.getSourceId(), game);
                    ++affectedTargets;
                    continue;
                }
                if (!this.useOnCard || (card = game.getCard(objectId)) == null) continue;
                game.getState().addOtherAbility(card, this.ability);
                ++affectedTargets;
            }
        }
        return affectedTargets > 0;
    }

    private Ability copyAbility(Ability toCopyAbility) {
        Ability abilityToCopy = toCopyAbility.copy();
        abilityToCopy.newId();
        if (abilityToCopy instanceof LinkedEffectIdStaticAbility) {
            ((LinkedEffectIdStaticAbility)abilityToCopy).setEffectIdManually();
        }
        return abilityToCopy;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? " gain " : " gains ");
        sb.append(CardUtil.stripReminderText(this.ability.getRule()));
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ').append(this.duration.toString());
        }
        return sb.toString();
    }
}

