/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Collections;
import java.util.function.Consumer;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.UseAttachedCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.Targets;
import mage.target.targetpointer.FixedTarget;

public class GainAbilityWithAttachmentEffect
extends ContinuousEffectImpl {
    private final Effects effects = new Effects(new Effect[0]);
    private final Targets targets = new Targets();
    private final Costs<Cost> costs = new CostsImpl<Cost>();
    protected final UseAttachedCost useAttachedCost;
    private final Consumer<ActivatedAbility> consumer;

    public GainAbilityWithAttachmentEffect(String rule, Effect effect, Target target, UseAttachedCost attachedCost, Cost ... costs) {
        this(rule, new Effects(effect), new Targets(target), attachedCost, costs);
    }

    public GainAbilityWithAttachmentEffect(String rule, Effects effects, Targets targets, UseAttachedCost attachedCost, Cost ... costs) {
        this(rule, effects, targets, attachedCost, (Consumer<ActivatedAbility>)null, costs);
    }

    public GainAbilityWithAttachmentEffect(String rule, Effects effects, Targets targets, UseAttachedCost attachedCost, Consumer<ActivatedAbility> consumer, Cost ... costs) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = rule;
        this.effects.addAll(effects);
        this.targets.addAll(targets);
        Collections.addAll(this.costs, costs);
        this.useAttachedCost = attachedCost;
        this.consumer = consumer;
        this.generateGainAbilityDependencies(this.makeAbility(null, null), null);
    }

    protected GainAbilityWithAttachmentEffect(GainAbilityWithAttachmentEffect effect) {
        super(effect);
        this.effects.addAll(effect.effects);
        this.targets.addAll(effect.targets);
        this.costs.addAll(effect.costs);
        this.useAttachedCost = effect.useAttachedCost == null ? null : effect.useAttachedCost.copy();
        this.consumer = effect.consumer;
    }

    @Override
    public GainAbilityWithAttachmentEffect copy() {
        return new GainAbilityWithAttachmentEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        Permanent equipment;
        if (this.getAffectedObjectsSetAtInit(source) && (equipment = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && equipment.getAttachedTo() != null) {
            this.setTargetPointer(new FixedTarget(equipment.getAttachedTo(), game.getState().getZoneChangeCounter(equipment.getAttachedTo())));
        }
        super.init(source, game);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = null;
        if (this.getAffectedObjectsSet()) {
            permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent == null) {
                this.discard();
                return true;
            }
        } else {
            Permanent equipment = game.getPermanent(source.getSourceId());
            if (equipment != null && equipment.getAttachedTo() != null) {
                permanent = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo());
            }
        }
        if (permanent == null) {
            return true;
        }
        Ability ability = this.makeAbility(game, source);
        ability.getEffects().setValue("attachedPermanent", game.getPermanent(source.getSourceId()));
        permanent.addAbility(ability, source.getSourceId(), game);
        return true;
    }

    protected Ability makeAbility(Game game, Ability source) {
        SimpleActivatedAbility ability = new SimpleActivatedAbility(null, null);
        for (Effect effect : this.effects) {
            if (effect == null) continue;
            ability.addEffect(effect.copy());
        }
        for (Target target : this.targets) {
            if (target == null) continue;
            ability.addTarget(target);
        }
        for (Cost cost : this.costs) {
            if (cost == null) continue;
            ability.addCost(cost.copy());
        }
        if (source != null && game != null) {
            ability.addCost(this.useAttachedCost.copy().setMageObjectReference(source, game));
        }
        if (this.consumer != null) {
            this.consumer.accept(ability);
        }
        return ability;
    }
}

