/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class GainProtectionFromColorTargetEffect
extends GainAbilityTargetEffect {
    protected ChoiceColor choice;

    public GainProtectionFromColorTargetEffect(Duration duration) {
        this(duration, (ObjectColor)null);
    }

    public GainProtectionFromColorTargetEffect(Duration duration, ObjectColor protectColor) {
        super(new ProtectionAbility(new FilterCard()), duration);
        this.choice = new ChoiceColor(true, "Choose a color to gain protection against it");
        if (protectColor != null) {
            this.choice.setChoice(protectColor.toString());
        }
    }

    protected GainProtectionFromColorTargetEffect(GainProtectionFromColorTargetEffect effect) {
        super(effect);
        this.choice = effect.choice.copy();
    }

    @Override
    public GainProtectionFromColorTargetEffect copy() {
        return new GainProtectionFromColorTargetEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (sourceObject != null && controller != null && controller.choose(Outcome.Protect, this.choice, game)) {
            game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen protection from " + this.choice.getChoice());
            return;
        }
        this.discard();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null) {
            FilterCard protectionFilter = (FilterCard)((ProtectionAbility)this.ability).getFilter();
            protectionFilter.add(new ColorPredicate(this.choice.getColor()));
            protectionFilter.setMessage(this.choice.getChoice());
            ((ProtectionAbility)this.ability).setFilter(protectionFilter);
            creature.addAbility(this.ability, source.getSourceId(), game);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + " gains protection from the color of your choice " + this.duration.toString();
    }
}

