/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class GainProtectionFromTypeTargetEffect
extends GainAbilityTargetEffect {
    private String typeName;

    public GainProtectionFromTypeTargetEffect(Duration duration, FilterCard protectionFrom) {
        super(new ProtectionAbility(new FilterCard()), duration);
        ((ProtectionAbility)this.ability).setFilter(protectionFrom);
        this.typeName = protectionFrom.getMessage();
        this.staticText = "Target creature gains protection from " + this.typeName + ' ' + duration.toString();
    }

    protected GainProtectionFromTypeTargetEffect(GainProtectionFromTypeTargetEffect effect) {
        super(effect);
        this.typeName = effect.typeName;
    }

    @Override
    public GainProtectionFromTypeTargetEffect copy() {
        return new GainProtectionFromTypeTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature != null) {
            creature.addAbility(this.ability, source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

