/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.game.Game;
import mage.players.Player;

public class LookAtOpponentFaceDownCreaturesAnyTimeEffect
extends ContinuousEffectImpl {
    private final FilterCreaturePermanent filter;

    public LookAtOpponentFaceDownCreaturesAnyTimeEffect() {
        this(Duration.WhileOnBattlefield);
    }

    public LookAtOpponentFaceDownCreaturesAnyTimeEffect(Duration duration) {
        this(duration, TargetController.NOT_YOU);
    }

    public LookAtOpponentFaceDownCreaturesAnyTimeEffect(Duration duration, TargetController targetController) {
        super(duration, Layer.PlayerEffects, SubLayer.NA, Outcome.Benefit);
        this.staticText = LookAtOpponentFaceDownCreaturesAnyTimeEffect.makeText(duration, targetController);
        this.filter = new FilterCreaturePermanent();
        this.filter.add(FaceDownPredicate.instance);
        this.filter.add(targetController.getControllerPredicate());
    }

    protected LookAtOpponentFaceDownCreaturesAnyTimeEffect(LookAtOpponentFaceDownCreaturesAnyTimeEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return false;
        }
        controller.lookAtCards(source, "Face Down Creatures", cards, game);
        return true;
    }

    @Override
    public LookAtOpponentFaceDownCreaturesAnyTimeEffect copy() {
        return new LookAtOpponentFaceDownCreaturesAnyTimeEffect(this);
    }

    private static String makeText(Duration duration, TargetController targetController) {
        StringBuilder sb = new StringBuilder();
        if (!duration.toString().isEmpty()) {
            sb.append((Object)duration);
            sb.append(", ");
        }
        sb.append("you may look at face-down creatures ");
        switch (targetController) {
            case NOT_YOU: {
                sb.append("you don't control ");
                break;
            }
            case OPPONENT: {
                sb.append("your opponents control ");
            }
        }
        sb.append("any time");
        return sb.toString();
    }
}

