/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class LoseArtifactTypeTargetEffect
extends ContinuousEffectImpl {
    public LoseArtifactTypeTargetEffect(Duration duration) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
        this.setText("isn't an artifact");
    }

    protected LoseArtifactTypeTargetEffect(LoseArtifactTypeTargetEffect effect) {
        super(effect);
    }

    @Override
    public LoseArtifactTypeTargetEffect copy() {
        return new LoseArtifactTypeTargetEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.duration.isOnlyValidIfNoZoneChange() && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent;
            if (targetId == null || (permanent = game.getPermanent(targetId)) == null) continue;
            permanent.removeCardType(game, CardType.ARTIFACT);
            permanent.removeAllSubTypes(game, SubTypeSet.ArtifactType);
            return true;
        }
        return false;
    }
}

