/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;

public class PlayFromTopOfLibraryEffect
extends AsThoughEffectImpl {
    private final FilterCard filter;
    private static final FilterCard defaultFilter = new FilterCard("play lands and cast spells");

    public PlayFromTopOfLibraryEffect() {
        this(defaultFilter);
    }

    public PlayFromTopOfLibraryEffect(FilterCard filter) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.filter = filter;
        this.staticText = "you may " + filter.getMessage() + " from the top of your library";
    }

    protected PlayFromTopOfLibraryEffect(PlayFromTopOfLibraryEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public PlayFromTopOfLibraryEffect copy() {
        return new PlayFromTopOfLibraryEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    @Override
    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck == null) {
            return false;
        }
        if (affectedAbility instanceof SpellAbility) {
            SpellAbility spell = (SpellAbility)affectedAbility;
            cardToCheck = spell.getCharacteristics(game);
            if (spell.getManaCosts().isEmpty()) {
                return false;
            }
        }
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        Player cardOwner = game.getPlayer(cardToCheck.getOwnerId());
        Player controller = game.getPlayer(source.getControllerId());
        if (cardOwner == null || controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard == null || !topCard.getId().equals(cardToCheck.getMainCard().getId())) {
            return false;
        }
        return this.filter.match(cardToCheck, playerId, source, game);
    }
}

