/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

public class SetBasePowerToughnessSourceEffect
extends ContinuousEffectImpl {
    private final DynamicValue power;
    private final DynamicValue toughness;

    protected SetBasePowerToughnessSourceEffect(DynamicValue power, DynamicValue toughness, Duration duration, SubLayer subLayer) {
        super(duration, Layer.PTChangingEffects_7, subLayer, Outcome.BoostCreature);
        this.setCharacterDefining(subLayer == SubLayer.CharacteristicDefining_7a);
        this.power = power;
        this.toughness = toughness;
    }

    public SetBasePowerToughnessSourceEffect(DynamicValue amount) {
        this(amount, amount, Duration.EndOfGame, SubLayer.CharacteristicDefining_7a);
        this.staticText = "{this}'s power and toughness are each equal to the number of " + amount.getMessage();
    }

    public SetBasePowerToughnessSourceEffect(DynamicValue amount, Duration duration) {
        this(amount, amount, duration, SubLayer.SetPT_7b);
        this.staticText = duration.toString().isEmpty() ? "{this}'s power and toughness are each equal to the number of " + amount.getMessage() : "{this} has base power and toughness each equal to the number of " + amount.getMessage() + " " + (Object)((Object)duration);
    }

    public SetBasePowerToughnessSourceEffect(DynamicValue power, DynamicValue toughness, Duration duration, String text) {
        this(power, toughness, duration, SubLayer.SetPT_7b);
        this.staticText = text;
    }

    public SetBasePowerToughnessSourceEffect(int power, int toughness, Duration duration) {
        this((DynamicValue)StaticValue.get(power), (DynamicValue)StaticValue.get(toughness), duration, SubLayer.SetPT_7b);
        this.staticText = "{this} has base power and toughness " + power + '/' + toughness + ' ' + duration.toString();
    }

    protected SetBasePowerToughnessSourceEffect(SetBasePowerToughnessSourceEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    @Override
    public SetBasePowerToughnessSourceEffect copy() {
        return new SetBasePowerToughnessSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = this.characterDefining || this.duration == Duration.WhileOnBattlefield ? game.getObject(source) : source.getSourcePermanentIfItStillExists(game);
        }
        if (mageObject == null) {
            this.discard();
            return false;
        }
        if (this.power != null) {
            mageObject.getPower().setModifiedBaseValue(this.power.calculate(game, source, this));
        }
        if (this.toughness != null) {
            mageObject.getToughness().setModifiedBaseValue(this.toughness.calculate(game, source, this));
        }
        return true;
    }
}

