/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SwitchPowerToughnessSourceEffect
extends ContinuousEffectImpl {
    public SwitchPowerToughnessSourceEffect(Duration duration) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.SwitchPT_e, Outcome.BoostCreature);
        this.staticText = "switch {this}'s power and toughness " + duration.toString();
    }

    protected SwitchPowerToughnessSourceEffect(SwitchPowerToughnessSourceEffect effect) {
        super(effect);
    }

    @Override
    public SwitchPowerToughnessSourceEffect copy() {
        return new SwitchPowerToughnessSourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.duration.isOnlyValidIfNoZoneChange() && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) {
            if (this.duration.isOnlyValidIfNoZoneChange()) {
                this.discard();
            }
            return false;
        }
        sourcePermanent.switchPowerToughness();
        return true;
    }
}

