/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class VehiclesBecomeArtifactCreatureEffect
extends ContinuousEffectImpl {
    public VehiclesBecomeArtifactCreatureEffect(Duration duration) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.BecomeCreature);
        this.staticText = "Vehicles you control become artifact creatures until end of turn";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private VehiclesBecomeArtifactCreatureEffect(VehiclesBecomeArtifactCreatureEffect effect) {
        super(effect);
    }

    @Override
    public VehiclesBecomeArtifactCreatureEffect copy() {
        return new VehiclesBecomeArtifactCreatureEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (permanent == null || !permanent.hasSubtype(SubType.VEHICLE, game) || sublayer != SubLayer.NA) continue;
            permanent.addCardType(game, CardType.ARTIFACT);
            permanent.addCardType(game, CardType.CREATURE);
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }
}

