/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.cost;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.choices.ChoiceImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class SpellsCostReductionAllEffect
extends CostModificationEffectImpl {
    private static final FilterCard defaultFilter = new FilterCard("Spells");
    private final FilterCard filter;
    private final int amount;
    private final boolean upTo;
    private final boolean onlyControlled;
    private UUID controllerId;

    public SpellsCostReductionAllEffect(int amount) {
        this(defaultFilter, amount);
    }

    public SpellsCostReductionAllEffect(FilterCard filter, int amount) {
        this(filter, amount, false);
    }

    public SpellsCostReductionAllEffect(FilterCard filter, int amount, boolean upTo) {
        this(filter, amount, upTo, false);
    }

    protected SpellsCostReductionAllEffect(FilterCard filter, int amount, boolean upTo, boolean onlyControlled) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.filter = filter;
        this.amount = amount;
        this.upTo = upTo;
        this.onlyControlled = onlyControlled;
        this.staticText = filter.getMessage() + " cost " + (upTo ? "up to " : "") + '{' + amount + "} less to cast";
        this.controllerId = null;
    }

    protected SpellsCostReductionAllEffect(SpellsCostReductionAllEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.amount = effect.amount;
        this.upTo = effect.upTo;
        this.onlyControlled = effect.onlyControlled;
        this.controllerId = effect.controllerId;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (this.upTo) {
            if (game.inCheckPlayableState()) {
                CardUtil.reduceCost(abilityToModify, this.amount);
                return true;
            }
            Mana mana = abilityToModify.getManaCostsToPay().getMana();
            int reduceMax = mana.getGeneric();
            if (reduceMax > this.amount) {
                reduceMax = this.amount;
            }
            if (reduceMax <= 0) return true;
            Player controller = game.getPlayer(abilityToModify.getControllerId());
            if (controller == null) {
                return false;
            }
            ChoiceImpl choice = new ChoiceImpl(true);
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (int i = 0; i <= reduceMax; ++i) {
                set.add(String.valueOf(i));
            }
            choice.setChoices(set);
            choice.setMessage("Reduce cost of " + this.filter);
            if (!controller.choose(Outcome.Benefit, choice, game)) return false;
            int reduce = Integer.parseInt(choice.getChoice());
            CardUtil.reduceCost(abilityToModify, reduce);
            return true;
        } else {
            CardUtil.reduceCost(abilityToModify, this.amount);
        }
        return true;
    }

    protected boolean selectedByRuntimeData(Card card, Ability source, Game game) {
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card spellCard;
        if (this.onlyControlled && !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        if (this.controllerId != null && !abilityToModify.isControlledBy(this.controllerId)) {
            return false;
        }
        if (abilityToModify instanceof SpellAbility && (spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game)) != null) {
            return this.filter.match(spellCard, game) && this.selectedByRuntimeData(spellCard, source, game);
        }
        return false;
    }

    public void setControllerId(UUID controllerId) {
        this.controllerId = controllerId;
    }

    @Override
    public SpellsCostReductionAllEffect copy() {
        return new SpellsCostReductionAllEffect(this);
    }
}

