/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.cost;

import java.util.LinkedHashSet;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.choices.ChoiceImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class SpellsCostReductionControllerEffect
extends CostModificationEffectImpl {
    private final FilterCard filter;
    private final DynamicValue amount;
    private final boolean upTo;
    private ManaCosts<ManaCost> manaCostsToReduce = null;
    private final boolean convertToGeneric;

    public SpellsCostReductionControllerEffect(FilterCard filter, ManaCosts<ManaCost> manaCostsToReduce) {
        this(filter, manaCostsToReduce, StaticValue.get(1));
    }

    public SpellsCostReductionControllerEffect(FilterCard filter, ManaCosts<ManaCost> manaCostsToReduce, DynamicValue amount) {
        this(filter, manaCostsToReduce, amount, false);
    }

    public SpellsCostReductionControllerEffect(FilterCard filter, ManaCosts<ManaCost> manaCostsToReduce, DynamicValue amount, boolean convertToGeneric) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.filter = filter;
        this.amount = amount;
        this.manaCostsToReduce = manaCostsToReduce;
        this.upTo = false;
        this.convertToGeneric = convertToGeneric;
        this.createStaticText();
    }

    public SpellsCostReductionControllerEffect(FilterCard filter, int amount) {
        this(filter, StaticValue.get(amount), false);
    }

    public SpellsCostReductionControllerEffect(FilterCard filter, int amount, boolean upTo) {
        this(filter, StaticValue.get(amount), upTo);
    }

    public SpellsCostReductionControllerEffect(FilterCard filter, DynamicValue amount) {
        this(filter, amount, false);
    }

    public SpellsCostReductionControllerEffect(FilterCard filter, DynamicValue amount, boolean upTo) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.filter = filter;
        this.amount = amount;
        this.upTo = upTo;
        this.convertToGeneric = false;
        this.createStaticText();
    }

    protected SpellsCostReductionControllerEffect(SpellsCostReductionControllerEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.amount = effect.amount;
        this.manaCostsToReduce = effect.manaCostsToReduce;
        this.upTo = effect.upTo;
        this.convertToGeneric = effect.convertToGeneric;
        this.staticText = effect.staticText;
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int reductionAmount = this.amount.calculate(game, source, this);
        if (this.manaCostsToReduce != null) {
            ManaCostsImpl<ManaCost> calculatedManaCostsToReduce = new ManaCostsImpl<ManaCost>();
            for (int i = 0; i < reductionAmount; ++i) {
                calculatedManaCostsToReduce.add(this.manaCostsToReduce.copy());
            }
            CardUtil.adjustCost(abilityToModify, calculatedManaCostsToReduce, this.convertToGeneric);
        } else if (this.upTo) {
            Mana mana = abilityToModify.getManaCostsToPay().getMana();
            int reduceMax = mana.getGeneric();
            if (reduceMax > reductionAmount) {
                reduceMax = reductionAmount;
            }
            if (reduceMax > 0) {
                Player controller = game.getPlayer(abilityToModify.getControllerId());
                if (controller == null) {
                    return false;
                }
                int reduce = reduceMax;
                if (!game.inCheckPlayableState()) {
                    ChoiceImpl choice = new ChoiceImpl(false);
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (int i = 0; i <= reduceMax; ++i) {
                        set.add(String.valueOf(i));
                    }
                    choice.setChoices(set);
                    MageObject mageObject = game.getObject(abilityToModify.getSourceId());
                    choice.setMessage("Reduce cost of " + (mageObject != null ? mageObject.getIdName() : this.filter.getMessage()));
                    reduce = controller.choose(Outcome.Benefit, choice, game) ? Integer.parseInt(choice.getChoice()) : reduceMax;
                }
                if (reduce > 0) {
                    CardUtil.reduceCost(abilityToModify, reduce);
                }
            }
        } else {
            CardUtil.reduceCost(abilityToModify, reductionAmount);
        }
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card spellCard;
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && (spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game)) != null) {
            return this.filter.match(spellCard, source.getControllerId(), source, game);
        }
        return false;
    }

    private void createStaticText() {
        StringBuilder sb = new StringBuilder(this.filter.getMessage());
        if (!sb.toString().contains("you cast")) {
            sb.append(" you cast");
        }
        if (sb.toString().toLowerCase().contains("spells")) {
            sb.append(" cost ");
        } else {
            sb.append(" costs ");
        }
        if (this.upTo) {
            sb.append("up to ");
        }
        if (this.manaCostsToReduce != null) {
            sb.append(this.manaCostsToReduce.getText());
            if (this.convertToGeneric) {
                sb.append(" (<i>or {1}</i>)");
            }
        } else {
            sb.append("{").append(this.amount).append("}");
        }
        sb.append(" less to cast");
        if (!(this.amount instanceof StaticValue)) {
            sb.append(" for each ").append(this.amount.getMessage());
        }
        if (!this.convertToGeneric && this.manaCostsToReduce != null) {
            sb.append(". This effect reduces only the amount of colored mana you pay");
        }
        this.staticText = sb.toString();
    }

    @Override
    public SpellsCostReductionControllerEffect copy() {
        return new SpellsCostReductionControllerEffect(this);
    }
}

