/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class AddCountersAttachedEffect
extends OneShotEffect {
    private Counter counter;
    private DynamicValue amount;

    public AddCountersAttachedEffect(Counter counter, String textEnchanted) {
        this(counter, StaticValue.get(1), textEnchanted);
    }

    public AddCountersAttachedEffect(Counter counter, DynamicValue amount, String textEnchanted) {
        super(Outcome.Benefit);
        this.counter = counter.copy();
        this.amount = amount;
        this.staticText = CardUtil.getAddRemoveCountersText(amount, counter, textEnchanted, true);
    }

    protected AddCountersAttachedEffect(AddCountersAttachedEffect effect) {
        super(effect);
        if (effect.counter != null) {
            this.counter = effect.counter.copy();
        }
        this.amount = effect.amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.getAttachedTo() != null) {
            Permanent attachedTo = game.getPermanent(permanent.getAttachedTo());
            if (attachedTo != null && this.counter != null) {
                Counter newCounter = this.counter.copy();
                int countersToAdd = this.amount.calculate(game, source, this);
                if (countersToAdd > 0) {
                    newCounter.add(--countersToAdd);
                    attachedTo.addCounters(newCounter, source.getControllerId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public AddCountersAttachedEffect copy() {
        return new AddCountersAttachedEffect(this);
    }
}

