/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class AddCountersSourceEffect
extends OneShotEffect {
    private Counter counter;
    private boolean informPlayers;
    private DynamicValue amount;
    private boolean putOnCard;

    public AddCountersSourceEffect(Counter counter) {
        this(counter, false);
    }

    public AddCountersSourceEffect(Counter counter, boolean informPlayers) {
        this(counter, StaticValue.get(0), informPlayers);
    }

    public AddCountersSourceEffect(Counter counter, DynamicValue amount) {
        this(counter, amount, true);
    }

    public AddCountersSourceEffect(Counter counter, DynamicValue amount, boolean informPlayers) {
        this(counter, amount, informPlayers, false);
    }

    public AddCountersSourceEffect(Counter counter, DynamicValue amount, boolean informPlayers, boolean putOnCard) {
        super(Outcome.Benefit);
        this.counter = counter.copy();
        this.informPlayers = informPlayers;
        this.amount = amount;
        this.putOnCard = putOnCard;
        this.staticText = CardUtil.getAddRemoveCountersText(amount, counter, "{this}", true);
    }

    protected AddCountersSourceEffect(AddCountersSourceEffect effect) {
        super(effect);
        if (effect.counter != null) {
            this.counter = effect.counter.copy();
        }
        this.informPlayers = effect.informPlayers;
        this.amount = effect.amount;
        this.putOnCard = effect.putOnCard;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.counter == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (this.putOnCard) {
            Player player;
            Card card = game.getCard(source.getSourceId());
            if (card == null) {
                return false;
            }
            Counter newCounter = this.counter.copy();
            int countersToAdd = this.amount.calculate(game, source, this);
            if (countersToAdd > 0 && newCounter.getCount() == 1) {
                --countersToAdd;
            }
            newCounter.add(countersToAdd);
            ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
            card.addCounters(newCounter, source.getControllerId(), source, game, appliedEffects);
            if (this.informPlayers && !game.isSimulation() && (player = game.getPlayer(source.getControllerId())) != null) {
                game.informPlayers(player.getLogName() + " puts " + newCounter.getCount() + ' ' + newCounter.getName() + " counter on " + card.getLogName());
            }
            return true;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        if (permanent == null) {
            return false;
        }
        if (source.getStackMomentSourceZCC() == 0 || source.getStackMomentSourceZCC() == permanent.getZoneChangeCounter(game)) {
            Counter newCounter = this.counter.copy();
            int countersToAdd = this.amount.calculate(game, source, this);
            if (this.amount instanceof StaticValue || countersToAdd > 0) {
                if (countersToAdd > 0 && newCounter.getCount() == 1) {
                    --countersToAdd;
                }
                newCounter.add(countersToAdd);
                int before = permanent.getCounters(game).getCount(newCounter.getName());
                ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
                permanent.addCounters(newCounter, source.getControllerId(), source, game, appliedEffects);
                if (this.informPlayers && !game.isSimulation()) {
                    int amountAdded = permanent.getCounters(game).getCount(newCounter.getName()) - before;
                    Player player = game.getPlayer(source.getControllerId());
                    if (player != null) {
                        game.informPlayers(player.getLogName() + " puts " + amountAdded + ' ' + newCounter.getName() + " counter on " + permanent.getLogName());
                    }
                }
            }
        }
        return true;
    }

    @Override
    public AddCountersSourceEffect copy() {
        return new AddCountersSourceEffect(this);
    }
}

