/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class AddPoisonCounterTargetEffect
extends OneShotEffect {
    protected int amount;

    public AddPoisonCounterTargetEffect(int amount) {
        super(Outcome.Damage);
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    protected AddPoisonCounterTargetEffect(AddPoisonCounterTargetEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public AddPoisonCounterTargetEffect copy() {
        return new AddPoisonCounterTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            player.addCounters(CounterType.POISON.createInstance(this.amount), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + (this.getTargetPointer().isPlural(mode.getTargets()) ? " get " : " gets ") + CardUtil.getSimpleCountersText(this.amount, "a", "poison");
    }
}

