/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.replacement;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.DefenderAttackedEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.permanent.Permanent;

public class AdditionalTriggersAttackingReplacementEffect
extends ReplacementEffectImpl {
    private final boolean onlyControlled;

    public AdditionalTriggersAttackingReplacementEffect(boolean onlyControlled) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.onlyControlled = onlyControlled;
        this.staticText = "if a creature " + (onlyControlled ? "you control " : "") + "attacking causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private AdditionalTriggersAttackingReplacementEffect(AdditionalTriggersAttackingReplacementEffect effect) {
        super(effect);
        this.onlyControlled = effect.onlyControlled;
    }

    @Override
    public AdditionalTriggersAttackingReplacementEffect copy() {
        return new AdditionalTriggersAttackingReplacementEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
        Permanent sourcePermanent = game.getPermanent(numberOfTriggersEvent.getSourceId());
        if (sourcePermanent == null) return false;
        if (!sourcePermanent.isControlledBy(source.getControllerId())) {
            return false;
        }
        GameEvent sourceEvent = numberOfTriggersEvent.getSourceEvent();
        if (sourceEvent == null) {
            return false;
        }
        switch (sourceEvent.getType()) {
            case ATTACKER_DECLARED: {
                if (!this.onlyControlled) return true;
                if (!source.isControlledBy(sourceEvent.getPlayerId())) return false;
                return true;
            }
            case DECLARED_ATTACKERS: {
                if (!this.onlyControlled) return true;
                if (!game.getCombat().getAttackers().stream().map(game::getControllerId).anyMatch(source::isControlledBy)) return false;
                return true;
            }
            case DEFENDER_ATTACKED: {
                if (!this.onlyControlled) return true;
                if (!((DefenderAttackedEvent)sourceEvent).getAttackers(game).stream().map(Controllable::getControllerId).anyMatch(source::isControlledBy)) return false;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

