/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.ruleModifying;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.CastSpellLastTurnWatcher;

public class CastOnlyIfYouHaveCastAnotherSpellEffect
extends ContinuousRuleModifyingEffectImpl {
    public CastOnlyIfYouHaveCastAnotherSpellEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "Cast this spell only if you've cast another spell this turn";
    }

    protected CastOnlyIfYouHaveCastAnotherSpellEffect(CastOnlyIfYouHaveCastAnotherSpellEffect effect) {
        super(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        CastSpellLastTurnWatcher watcher;
        return event.getSourceId().equals(source.getSourceId()) && (watcher = game.getState().getWatcher(CastSpellLastTurnWatcher.class)) != null && watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId()) == 0;
    }

    @Override
    public CastOnlyIfYouHaveCastAnotherSpellEffect copy() {
        return new CastOnlyIfYouHaveCastAnotherSpellEffect(this);
    }
}

