/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class SearchLibraryPutInGraveyardEffect
extends SearchEffect {
    public SearchLibraryPutInGraveyardEffect(boolean textThatCard) {
        super(new TargetCardInLibrary(StaticFilters.FILTER_CARD), Outcome.Neutral);
        this.staticText = "search your library for a card, put " + (textThatCard ? "that card" : "it") + " into your graveyard, then shuffle";
    }

    protected SearchLibraryPutInGraveyardEffect(SearchLibraryPutInGraveyardEffect effect) {
        super(effect);
    }

    @Override
    public SearchLibraryPutInGraveyardEffect copy() {
        return new SearchLibraryPutInGraveyardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            controller.moveCards(game.getCard(this.target.getFirstTarget()), Zone.GRAVEYARD, source, game);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

