/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class SearchLibraryPutInPlayTargetControllerEffect
extends SearchEffect {
    private final boolean tapped;

    public SearchLibraryPutInPlayTargetControllerEffect(boolean tapped) {
        this(new TargetCardInLibrary(StaticFilters.FILTER_CARD_BASIC_LAND), tapped, Outcome.PutLandInPlay, "its controller");
    }

    public SearchLibraryPutInPlayTargetControllerEffect(TargetCardInLibrary target, boolean tapped, Outcome outcome, String whoSearch) {
        super(target, outcome);
        this.tapped = tapped;
        this.staticText = whoSearch + " may search their library for " + target.getDescription() + (target.getMaxNumberOfTargets() > 1 ? ", put them onto the battlefield" : ", put it onto the battlefield") + (tapped ? " tapped" : "") + ", then shuffle";
    }

    protected SearchLibraryPutInPlayTargetControllerEffect(SearchLibraryPutInPlayTargetControllerEffect effect) {
        super(effect);
        this.tapped = effect.tapped;
    }

    @Override
    public SearchLibraryPutInPlayTargetControllerEffect copy() {
        return new SearchLibraryPutInPlayTargetControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = this.getTargetPointer().getControllerOfFirstTargetOrLKI(game, source);
        if (player == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Search your library for " + this.target.getDescription() + '?', source, game)) {
            return true;
        }
        if (player.searchLibrary(this.target, source, game) && !this.target.getTargets().isEmpty()) {
            player.moveCards(new CardsImpl((Collection<UUID>)this.target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, this.tapped, false, false, null);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

