/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.SearchEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class SearchLibraryPutInPlayTargetPlayerEffect
extends SearchEffect {
    protected boolean tapped;
    protected boolean ownerIsController;

    public SearchLibraryPutInPlayTargetPlayerEffect(TargetCardInLibrary target, boolean tapped) {
        this(target, tapped, false);
    }

    public SearchLibraryPutInPlayTargetPlayerEffect(TargetCardInLibrary target, boolean tapped, boolean ownerIsController) {
        super(target, Outcome.PutCardInPlay);
        this.tapped = tapped;
        this.ownerIsController = ownerIsController;
        if (target.getDescription().contains("land")) {
            this.outcome = Outcome.PutLandInPlay;
        } else if (target.getDescription().contains("creature")) {
            this.outcome = Outcome.PutCreatureInPlay;
        }
    }

    protected SearchLibraryPutInPlayTargetPlayerEffect(SearchLibraryPutInPlayTargetPlayerEffect effect) {
        super(effect);
        this.tapped = effect.tapped;
        this.ownerIsController = effect.ownerIsController;
    }

    @Override
    public SearchLibraryPutInPlayTargetPlayerEffect copy() {
        return new SearchLibraryPutInPlayTargetPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            if (player.searchLibrary(this.target, source, game)) {
                if (!this.target.getTargets().isEmpty()) {
                    player.moveCards(new CardsImpl((Collection<UUID>)this.target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, this.tapped, false, this.ownerIsController, null);
                }
                player.shuffleLibrary(source, game);
                return true;
            }
            player.shuffleLibrary(source, game);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + " searches their library for " + this.target.getDescription() + ", " + (this.target.getMaxNumberOfTargets() > 1 ? "puts them onto the battlefield" : "puts it onto the battlefield") + (this.tapped ? " tapped" : "") + ", then shuffles";
    }
}

