/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.turn;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.turn.LoseGameDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

public class AddExtraTurnControllerEffect
extends OneShotEffect {
    private final boolean loseGameAtEnd;
    private final TurnModApplier turnModApplier;

    public AddExtraTurnControllerEffect() {
        this(false);
    }

    public AddExtraTurnControllerEffect(boolean loseGameAtEnd) {
        this(loseGameAtEnd, null);
    }

    public AddExtraTurnControllerEffect(boolean loseGameAtEnd, TurnModApplier turnModApplier) {
        super(loseGameAtEnd ? Outcome.AIDontUseIt : Outcome.ExtraTurn);
        this.loseGameAtEnd = loseGameAtEnd;
        this.turnModApplier = turnModApplier;
    }

    protected AddExtraTurnControllerEffect(AddExtraTurnControllerEffect effect) {
        super(effect);
        this.loseGameAtEnd = effect.loseGameAtEnd;
        this.turnModApplier = effect.turnModApplier;
    }

    @Override
    public AddExtraTurnControllerEffect copy() {
        return new AddExtraTurnControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return true;
        }
        TurnMod extraTurn = new TurnMod(player.getId()).withExtraTurn();
        game.getState().getTurnMods().add(extraTurn);
        if (this.loseGameAtEnd) {
            game.addDelayedTriggeredAbility(new LoseGameDelayedTriggeredAbility(extraTurn.getId()), source);
        }
        if (this.turnModApplier != null) {
            this.turnModApplier.apply(extraTurn.getId(), source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "take an extra turn after this one" + (this.loseGameAtEnd ? ". At the beginning of that turn's end step, you lose the game" : "");
    }

    @FunctionalInterface
    public static interface TurnModApplier {
        public void apply(UUID var1, Ability var2, Game var3);
    }
}

