/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class AirbendingCastEffect
extends AsThoughEffectImpl {
    AirbendingCastEffect(Card card, Game game) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.AIDontUseIt);
        this.setTargetPointer(new FixedTarget(card, game));
    }

    private AirbendingCastEffect(AirbendingCastEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public AirbendingCastEffect copy() {
        return new AirbendingCastEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            this.discard();
            return false;
        }
        if (!card.getId().equals(objectId) || !card.isOwnedBy(affectedControllerId)) {
            return false;
        }
        Player player = game.getPlayer(affectedControllerId);
        if (player == null) {
            return false;
        }
        CostsImpl<Cost> newCosts = new CostsImpl<Cost>();
        newCosts.addAll(card.getSpellAbility().getCosts());
        player.setCastSourceIdWithAlternateMana(card.getId(), new ManaCostsImpl<ManaCost>("{2}"), newCosts);
        return true;
    }
}

