/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ConniveSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;

public class ConniveTargetEffect
extends OneShotEffect {
    public ConniveTargetEffect() {
        super(Outcome.Benefit);
    }

    private ConniveTargetEffect(ConniveTargetEffect effect) {
        super(effect);
    }

    @Override
    public ConniveTargetEffect copy() {
        return new ConniveTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            ConniveSourceEffect.connive(game.getPermanent(targetId), 1, source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + " connives";
    }
}

