/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class AddManaFromColorChoicesEffect
extends ManaEffect {
    private final List<ManaType> manaTypes = new ArrayList<ManaType>();
    private final List<Mana> netMana = new ArrayList<Mana>();

    public AddManaFromColorChoicesEffect(ManaType ... manaTypes) {
        for (ManaType manaType : manaTypes) {
            this.manaTypes.add(manaType);
        }
        this.manaTypes.stream().map(CardUtil::manaTypeToColoredManaSymbol).map(Mana::new).forEach(this.netMana::add);
        this.staticText = "add " + CardUtil.concatWithOr(this.netMana.stream().map(Mana::toString).collect(Collectors.toList()));
    }

    private AddManaFromColorChoicesEffect(AddManaFromColorChoicesEffect effect) {
        super(effect);
        this.manaTypes.addAll(effect.manaTypes);
        effect.netMana.stream().map(Mana::copy).forEach(this.netMana::add);
    }

    @Override
    public AddManaFromColorChoicesEffect copy() {
        return new AddManaFromColorChoicesEffect(this);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        return this.netMana;
    }

    public List<Mana> getNetMana() {
        return this.netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game == null || this.manaTypes.isEmpty()) {
            return null;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(this.manaTypes, false);
        if (choice.getChoices().size() <= 1) {
            choice.setChoice(choice.getChoices().iterator().next());
        } else {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null || !player.choose(Outcome.PutManaInPool, choice, game)) {
                return null;
            }
        }
        ManaType chosenType = ManaType.findByName(choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType);
    }
}

