/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ManaOptions;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.constants.MultiAmountType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class AddManaInAnyCombinationEffect
extends ManaEffect {
    private List<ColoredManaSymbol> manaSymbols = new ArrayList<ColoredManaSymbol>();
    private final DynamicValue amount;
    private final DynamicValue netAmount;

    public AddManaInAnyCombinationEffect(int amount) {
        this(StaticValue.get(amount), StaticValue.get(amount), ColoredManaSymbol.W, ColoredManaSymbol.U, ColoredManaSymbol.B, ColoredManaSymbol.R, ColoredManaSymbol.G);
    }

    public AddManaInAnyCombinationEffect(int amount, ColoredManaSymbol ... coloredManaSymbols) {
        this(StaticValue.get(amount), StaticValue.get(amount), coloredManaSymbols);
    }

    public AddManaInAnyCombinationEffect(DynamicValue amount, DynamicValue netAmount, ColoredManaSymbol ... coloredManaSymbols) {
        this.manaSymbols.addAll(Arrays.asList(coloredManaSymbols));
        this.amount = amount;
        this.staticText = this.setText();
        this.netAmount = netAmount;
    }

    protected AddManaInAnyCombinationEffect(AddManaInAnyCombinationEffect effect) {
        super(effect);
        this.manaSymbols = effect.manaSymbols;
        this.amount = effect.amount;
        this.netAmount = effect.netAmount != null ? effect.netAmount.copy() : null;
    }

    @Override
    public AddManaInAnyCombinationEffect copy() {
        return new AddManaInAnyCombinationEffect(this);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        if (game.inCheckPlayableState()) {
            int count = this.netAmount.calculate(game, source, this);
            if (count <= 0) {
                return netMana;
            }
            ManaOptions allPossibleMana = new ManaOptions();
            for (int i = 0; i < count; ++i) {
                ManaOptions currentPossibleMana = new ManaOptions();
                if (this.manaSymbols.size() == 5) {
                    currentPossibleMana.add(new Mana(0, 0, 0, 0, 0, 0, 1, 0));
                } else {
                    for (ColoredManaSymbol coloredManaSymbol : this.manaSymbols) {
                        currentPossibleMana.add(new Mana(coloredManaSymbol));
                    }
                }
                allPossibleMana.addMana(currentPossibleMana);
            }
            allPossibleMana.removeFullyIncludedVariations();
            return new ArrayList<Mana>(allPossibleMana);
        }
        int amountOfManaLeft = this.amount.calculate(game, source, this);
        if (amountOfManaLeft > 0) {
            netMana.add(Mana.AnyMana(amountOfManaLeft));
        }
        return netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return null;
        }
        int size = this.manaSymbols.size();
        Mana mana = new Mana();
        ArrayList<String> manaStrings = new ArrayList<String>(size);
        for (ColoredManaSymbol coloredManaSymbol : this.manaSymbols) {
            manaStrings.add(coloredManaSymbol.toString());
        }
        int manaAmount = this.amount.calculate(game, source, this);
        List<Integer> manaList = player.getMultiAmount(this.outcome, manaStrings, 0, manaAmount, manaAmount, MultiAmountType.MANA, game);
        for (int i = 0; i < size; ++i) {
            mana.add(new Mana(this.manaSymbols.get(i), (int)manaList.get(i)));
        }
        return mana;
    }

    @Override
    public Set<ManaType> getProducableManaTypes(Game game, Ability source) {
        HashSet<ManaType> manaTypes = new HashSet<ManaType>();
        for (ColoredManaSymbol coloredManaSymbol : this.manaSymbols) {
            if (coloredManaSymbol.equals((Object)ColoredManaSymbol.B)) {
                manaTypes.add(ManaType.BLACK);
            }
            if (coloredManaSymbol.equals((Object)ColoredManaSymbol.R)) {
                manaTypes.add(ManaType.RED);
            }
            if (coloredManaSymbol.equals((Object)ColoredManaSymbol.G)) {
                manaTypes.add(ManaType.GREEN);
            }
            if (coloredManaSymbol.equals((Object)ColoredManaSymbol.U)) {
                manaTypes.add(ManaType.BLUE);
            }
            if (!coloredManaSymbol.equals((Object)ColoredManaSymbol.W)) continue;
            manaTypes.add(ManaType.WHITE);
        }
        return manaTypes;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("add ");
        String amountString = CardUtil.numberToText(this.amount.toString());
        sb.append(amountString);
        sb.append(" mana in any combination of ");
        if (this.manaSymbols.size() == 5) {
            sb.append("colors");
        } else {
            int i = 0;
            for (ColoredManaSymbol coloredManaSymbol : this.manaSymbols) {
                if (++i > 1) {
                    if (this.manaSymbols.size() > 2) {
                        sb.append(",");
                    }
                    if (i == this.manaSymbols.size()) {
                        sb.append(" and/or ");
                    } else {
                        sb.append(" ");
                    }
                }
                sb.append('{').append(coloredManaSymbol.toString()).append('}');
            }
        }
        if (amountString.equals("X") && !this.amount.getMessage().isEmpty()) {
            sb.append(", where X is ");
            sb.append(this.amount.getMessage());
        }
        return sb.toString();
    }
}

