/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.ManaChoice;
import mage.constants.ManaType;
import mage.game.Game;
import mage.players.Player;

public class AddManaOfTwoDifferentColorsEffect
extends ManaEffect {
    private static final List<ManaType> colorsToCycle = new ArrayList<ManaType>();
    private static final List<Mana> netMana = new ArrayList<Mana>();

    public AddManaOfTwoDifferentColorsEffect() {
        this.staticText = "Add two mana of different colors.";
    }

    private AddManaOfTwoDifferentColorsEffect(AddManaOfTwoDifferentColorsEffect effect) {
        super(effect);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        return netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            Player player = this.getPlayer(game, source);
            return ManaChoice.chooseTwoDifferentColors(player, game);
        }
        return new Mana();
    }

    @Override
    public AddManaOfTwoDifferentColorsEffect copy() {
        return new AddManaOfTwoDifferentColorsEffect(this);
    }

    static {
        colorsToCycle.add(ManaType.WHITE);
        colorsToCycle.add(ManaType.BLUE);
        colorsToCycle.add(ManaType.BLACK);
        colorsToCycle.add(ManaType.RED);
        colorsToCycle.add(ManaType.GREEN);
        for (ManaType manaType1 : colorsToCycle) {
            for (ManaType manaType2 : colorsToCycle) {
                if (manaType1 == manaType2) continue;
                Mana manaCombo = new Mana(manaType1);
                manaCombo.increase(manaType2);
                netMana.add(manaCombo);
            }
        }
    }
}

