/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.hint.Hint;
import mage.game.Game;

public class ValuePositiveHint
implements Hint {
    private final String name;
    private final DynamicValue value;

    public ValuePositiveHint(String name, DynamicValue value) {
        this.name = name;
        this.value = value;
    }

    private ValuePositiveHint(ValuePositiveHint hint) {
        this.name = hint.name;
        this.value = hint.value.copy();
    }

    @Override
    public String getText(Game game, Ability ability) {
        int amount = this.value.calculate(game, ability, null);
        return amount <= 0 ? "" : this.name + ": " + amount;
    }

    @Override
    public ValuePositiveHint copy() {
        return new ValuePositiveHint(this);
    }
}

