/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint.common;

import mage.abilities.Ability;
import mage.abilities.condition.common.CountersOnPermanentsCondition;
import mage.abilities.hint.Hint;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class CountersOnPermanentsHint
implements Hint {
    public final FilterPermanent filter;
    public final CounterType counterType;

    public CountersOnPermanentsHint(CountersOnPermanentsCondition condition) {
        this(condition.filter, condition.counterType);
    }

    public CountersOnPermanentsHint(FilterPermanent filter, CounterType counterType) {
        this.filter = filter;
        this.counterType = counterType;
    }

    public CountersOnPermanentsHint(CountersOnPermanentsHint hint) {
        this.filter = hint.filter.copy();
        this.counterType = hint.counterType;
    }

    @Override
    public String getText(Game game, Ability ability) {
        int totalCounters = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, ability.getControllerId(), ability, game)) {
            for (Counter counter : permanent.getCounters(game).values()) {
                if (!counter.getName().equals(this.counterType.getName())) continue;
                totalCounters += counter.getCount();
            }
        }
        return CardUtil.getTextWithFirstCharUpperCase(this.counterType.getName()) + " counters among " + this.filter.getMessage() + ": " + totalCounters;
    }

    @Override
    public CountersOnPermanentsHint copy() {
        return new CountersOnPermanentsHint(this);
    }
}

