/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint.common;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.condition.common.MonarchIsSourceControllerCondition;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.game.Game;

public enum MonarchHint implements Hint
{
    instance;

    private static final ConditionHint hint;

    @Override
    public String getText(Game game, Ability ability) {
        String res = hint.getText(game, ability);
        if (game.getMonarchId() == null) {
            return res + " (no monarch in the game)";
        }
        return res + Optional.ofNullable(game.getPlayer(game.getMonarchId())).map(p -> " (current monarch: " + p.getName() + ")").orElse("");
    }

    @Override
    public Hint copy() {
        return instance;
    }

    static {
        hint = new ConditionHint(MonarchIsSourceControllerCondition.instance, "You are The Monarch");
    }
}

