/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.SubCard;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.players.Player;

class AftermathExileAsResolvesFromGraveyard
extends ReplacementEffectImpl {
    AftermathExileAsResolvesFromGraveyard() {
        super(Duration.WhileOnStack, Outcome.Detriment);
        this.staticText = "Exile it afterwards.";
    }

    AftermathExileAsResolvesFromGraveyard(AftermathExileAsResolvesFromGraveyard effect) {
        super(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.STACK && zEvent.getToZone() != Zone.EXILED) {
            UUID sourceId = source != null ? source.getSourceId() : null;
            Card sourceCard = game.getCard(source.getSourceId());
            if (sourceCard instanceof SubCard) {
                sourceCard = ((SubCard)sourceCard).getParentCard();
                sourceId = sourceCard.getId();
            }
            if (zEvent.getTargetId().equals(sourceId)) {
                Spell spell = game.getStack().getSpell(source.getSourceId());
                return spell != null && spell.getFromZone() == Zone.GRAVEYARD;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player;
        Card sourceCard = game.getCard(source.getSourceId());
        if (sourceCard instanceof SubCard) {
            sourceCard = ((SubCard)sourceCard).getParentCard();
        }
        if (sourceCard != null && (player = game.getPlayer(sourceCard.getOwnerId())) != null) {
            return player.moveCards(sourceCard, Zone.EXILED, source, game);
        }
        return false;
    }

    @Override
    public AftermathExileAsResolvesFromGraveyard copy() {
        return new AftermathExileAsResolvesFromGraveyard(this);
    }
}

