/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class AnnihilatorAbility
extends TriggeredAbilityImpl {
    String rule;

    public AnnihilatorAbility(int count) {
        super(Zone.BATTLEFIELD, new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENTS, count, ""), false);
        this.rule = "Annihilator " + count + " <i>(Whenever this creature attacks, defending player sacrifices " + (count == 1 ? "a permanent" : CardUtil.numberToText(count) + " permanents") + ".)</i>";
    }

    protected AnnihilatorAbility(AnnihilatorAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defendingPlayerId;
        if (event.getSourceId().equals(this.getSourceId()) && (defendingPlayerId = game.getCombat().getDefendingPlayerId(this.sourceId, game)) != null) {
            this.getEffects().setTargetPointer(new FixedTarget(defendingPlayerId));
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    @Override
    public AnnihilatorAbility copy() {
        return new AnnihilatorAbility(this);
    }
}

