/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class AuraSwapEffect
extends OneShotEffect {
    AuraSwapEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Exchange this Aura with an Aura card in your hand.";
    }

    AuraSwapEffect(AuraSwapEffect effect) {
        super(effect);
    }

    @Override
    public AuraSwapEffect copy() {
        return new AuraSwapEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent auraSourcePermanent;
        FilterCard filterCardToCheck = new FilterCard();
        filterCardToCheck.add(SubType.AURA.getPredicate());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (auraSourcePermanent = game.getPermanent(source.getSourceId())) != null && auraSourcePermanent.hasSubtype(SubType.AURA, game) && auraSourcePermanent.isOwnedBy(source.getControllerId())) {
            Card auraInHand;
            Permanent enchantedPermanent = game.getPermanent(auraSourcePermanent.getAttachedTo());
            filterCardToCheck.add(new AuraCardCanAttachToPermanentId(enchantedPermanent.getId()));
            TargetCardInHand target = new TargetCardInHand(filterCardToCheck);
            if (controller.choose(Outcome.PutCardInPlay, target, source, game) && (auraInHand = game.getCard(target.getFirstTarget())) != null) {
                game.getState().setValue("attachTo:" + auraInHand.getId(), enchantedPermanent);
                controller.moveCards(auraInHand, Zone.BATTLEFIELD, source, game);
                enchantedPermanent.addAttachment(auraInHand.getId(), source, game);
                game.informPlayers(controller.getLogName() + " put " + auraInHand.getLogName() + " on the battlefield attached to " + enchantedPermanent.getLogName() + '.');
                enchantedPermanent.removeAttachment(auraSourcePermanent.getId(), source, game);
                return controller.moveCards(auraSourcePermanent, Zone.HAND, source, game);
            }
        }
        return false;
    }
}

