/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.AwakenElementalToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class AwakenEffect
extends OneShotEffect {
    static final String filterMessage = "a land you control to awake";
    private final int awakenValue;

    AwakenEffect(int awakenValue) {
        super(Outcome.BoostCreature);
        this.awakenValue = awakenValue;
        this.staticText = "put " + CardUtil.getOneOneCountersText(awakenValue) + " on target land you control and it becomes a 0/0 Elemental creature with haste";
    }

    private AwakenEffect(AwakenEffect effect) {
        super(effect);
        this.awakenValue = effect.awakenValue;
    }

    @Override
    public AwakenEffect copy() {
        return new AwakenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        UUID targetId = null;
        if (source != null && source.getTargets() != null) {
            for (Target target : source.getTargets()) {
                if (target.getFilter() == null || !target.getFilter().getMessage().equals(filterMessage)) continue;
                targetId = target.getFirstTarget();
            }
            if (targetId != null) {
                FixedTarget blueprintTarget = new FixedTarget(targetId, game);
                BecomesCreatureTargetEffect continuousEffect = new BecomesCreatureTargetEffect(new AwakenElementalToken(), false, true, Duration.Custom);
                continuousEffect.setTargetPointer(blueprintTarget.copy());
                game.addEffect(continuousEffect, source);
                AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(this.awakenValue));
                effect.setTargetPointer(blueprintTarget.copy());
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

