/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Locale;
import mage.abilities.StaticAbility;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;

public class BandsWithOtherAbility
extends StaticAbility {
    private SubType subtype;
    private SuperType supertype;
    private String bandingName;

    public BandsWithOtherAbility() {
        this(null, null, null);
    }

    public BandsWithOtherAbility(SubType subtype) {
        this(subtype, null, null);
    }

    public BandsWithOtherAbility(SuperType supertype) {
        this(null, supertype, null);
    }

    public BandsWithOtherAbility(String bandingName) {
        this(null, null, bandingName);
    }

    public BandsWithOtherAbility(SubType subtype, SuperType supertype, String bandingName) {
        super(Zone.ALL, null);
        this.subtype = subtype;
        this.supertype = supertype;
        this.bandingName = bandingName;
    }

    public BandsWithOtherAbility(BandsWithOtherAbility ability) {
        super(ability);
        this.subtype = ability.subtype;
        this.supertype = ability.supertype;
        this.bandingName = ability.bandingName;
    }

    @Override
    public BandsWithOtherAbility copy() {
        return new BandsWithOtherAbility(this);
    }

    public SubType getSubtype() {
        return this.subtype;
    }

    public SuperType getSupertype() {
        return this.supertype;
    }

    public String getName() {
        return this.bandingName;
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder("bands with other");
        if (this.subtype != null) {
            return sb.append(' ').append(this.subtype.getDescription()).append('s').toString();
        }
        if (this.supertype != null) {
            return sb.append(' ').append(this.supertype.toString().toLowerCase(Locale.ENGLISH)).append(" creatures").toString();
        }
        if (this.bandingName != null) {
            return sb.append(" creatures named ").append(this.bandingName).toString();
        }
        return "all \"" + sb.toString() + "\" abilities";
    }
}

