/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.MonstrosityAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class BecomeMonstrousSourceEffect
extends OneShotEffect {
    BecomeMonstrousSourceEffect(DynamicValue monstrosityValue) {
        this(monstrosityValue, "");
    }

    BecomeMonstrousSourceEffect(DynamicValue monstrosityValue, String costAdjusterText) {
        super(Outcome.BoostCreature);
        this.staticText = this.setText(monstrosityValue, costAdjusterText);
    }

    protected BecomeMonstrousSourceEffect(BecomeMonstrousSourceEffect effect) {
        super(effect);
    }

    @Override
    public BecomeMonstrousSourceEffect copy() {
        return new BecomeMonstrousSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.isMonstrous()) {
            return false;
        }
        int monstrosityValue = Optional.ofNullable(source).map(MonstrosityAbility.class::cast).map(MonstrosityAbility::getMonstrosityValue).map(dynamicValue -> dynamicValue.calculate(game, source, this)).map(i -> i == Integer.MAX_VALUE ? CardUtil.getSourceCostsTag(game, source, "X", 0) : i).orElse(0);
        permanent.addCounters(CounterType.P1P1.createInstance(monstrosityValue), source.getControllerId(), source, game);
        permanent.setMonstrous(true);
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.BECOMES_MONSTROUS, source.getSourceId(), source, source.getControllerId(), monstrosityValue));
        return true;
    }

    private String setText(DynamicValue monstrosityValue, String costAdjusterText) {
        if (!(monstrosityValue instanceof StaticValue)) {
            return "Monstrosity X, where X is " + monstrosityValue.getMessage() + ". " + costAdjusterText + "<i>(If this creature isn't monstrous, put X +1/+1 counters on it and it becomes monstrous.)</i>";
        }
        int value = ((StaticValue)monstrosityValue).getValue();
        return "Monstrosity " + (value == Integer.MAX_VALUE ? "X" : Integer.valueOf(value)) + ". " + costAdjusterText + "<i>(If this creature isn't monstrous, put " + (value == Integer.MAX_VALUE ? "X" : CardUtil.numberToText(value)) + " +1/+1 counters on it and it becomes monstrous.)</i>";
    }
}

