/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObject;
import mage.abilities.SpellAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.keyword.BestowTypeEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.TimingRule;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.common.TargetCreaturePermanent;
import mage.util.CardUtil;

public class BestowAbility
extends SpellAbility {
    public BestowAbility(Card card, String manaString) {
        super(new ManaCostsImpl(manaString), card.getName() + " using bestow");
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.spellAbilityCastMode = SpellAbilityCastMode.BESTOW;
        this.timing = TimingRule.SORCERY;
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.addTarget(auraTarget);
        this.addEffect(new AttachEffect(Outcome.BoostCreature));
        SimpleStaticAbility ability = new SimpleStaticAbility(new BestowTypeEffect());
        ability.setRuleVisible(false);
        this.addSubAbility(ability);
    }

    protected BestowAbility(BestowAbility ability) {
        super(ability);
    }

    @Override
    public BestowAbility copy() {
        return new BestowAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder("Bestow");
        Costs<Cost> costs = this.getCosts();
        if (costs.size() > 0) {
            sb.append("&mdash;").append(this.getManaCostsToPay().getText()).append(", ");
            sb.append(CardUtil.getTextWithFirstCharUpperCase(costs.getText())).append('.');
        } else {
            sb.append(" ").append(this.getManaCostsToPay().getText());
        }
        sb.append(" <i>(If you cast this card for its bestow cost, it's an Aura spell with enchant creature. It becomes a creature again if it's not attached to a creature.)</i>");
        return sb.toString();
    }

    public static void becomeAura(Card card) {
        if (card != null) {
            if (!card.getCardType().contains((Object)CardType.ENCHANTMENT)) {
                throw new IllegalStateException("Bestow perpetual becomeAura called on non-enchantment card");
            }
            card.addSubType(SubType.AURA);
            card.removeCardType(CardType.CREATURE);
            card.removeAllCreatureTypes();
            if (card instanceof Spell) {
                ((Spell)card).addAbilityForCopy(new EnchantAbility(new TargetCreaturePermanent()));
            } else {
                card.addAbility(new EnchantAbility(new TargetCreaturePermanent()));
            }
        }
    }

    public static void becomeAura(Game game, MageObject object) {
        if (object != null && object.getCardType(game).contains((Object)CardType.ENCHANTMENT)) {
            object.addSubType(game, SubType.AURA);
            object.removeCardType(game, CardType.CREATURE);
            object.removeAllCreatureTypes(game);
            if (object instanceof Permanent) {
                ((Permanent)object).addAbility(new EnchantAbility(new TargetCreaturePermanent()), object.getId(), game);
            } else if (object instanceof Spell) {
                game.getState().addOtherAbility(((Spell)object).getCard(), new EnchantAbility(new TargetCreaturePermanent()));
            } else if (object instanceof Card) {
                game.getState().addOtherAbility((Card)object, new EnchantAbility(new TargetCreaturePermanent()));
            } else {
                throw new IllegalArgumentException("Bestow temporary becomeAura called on non-Permanent non-Spell object: " + object.getClass().getName());
            }
        }
    }
}

