/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.BestowAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BestowTypeEffect
extends ContinuousEffectImpl {
    BestowTypeEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
    }

    private BestowTypeEffect(BestowTypeEffect effect) {
        super(effect);
    }

    @Override
    public BestowTypeEffect copy() {
        return new BestowTypeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        if (game.getPermanent(permanent.getAttachedTo()) != null) {
            BestowAbility.becomeAura(game, permanent);
        }
        return true;
    }
}

