/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.keyword.BuybackAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class BuybackEffect
extends ReplacementEffectImpl {
    public BuybackEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "When {this} resolves and you payed buyback costs, put it back to hand instead";
    }

    protected BuybackEffect(BuybackEffect effect) {
        super(effect);
    }

    @Override
    public BuybackEffect copy() {
        return new BuybackEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId())) {
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            return zEvent.getFromZone() == Zone.STACK && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.BATTLEFIELD) && source.getSourceId().equals(event.getSourceId());
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(source.getSourceId());
        if (card != null && source instanceof BuybackAbility && ((BuybackAbility)source).isBuybackActivated(game)) {
            return card.moveToZone(Zone.HAND, source, game, true, event.getAppliedEffects());
        }
        return false;
    }
}

