/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpecialAction;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.keyword.CompanionEffect;
import mage.abilities.keyword.CompanionCondition;
import mage.cards.Card;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;

public class CompanionAbility
extends SpecialAction {
    private final CompanionCondition companionCondition;

    public CompanionAbility(CompanionCondition companionCondition) {
        super(Zone.OUTSIDE);
        this.companionCondition = companionCondition;
        this.addCost(new GenericManaCost(3));
        this.addEffect(new CompanionEffect());
        this.setTiming(TimingRule.SORCERY);
    }

    private CompanionAbility(CompanionAbility ability) {
        super(ability);
        this.companionCondition = ability.companionCondition;
    }

    @Override
    public CompanionAbility copy() {
        return new CompanionAbility(this);
    }

    @Override
    public String getRule() {
        return "Companion &mdash; " + this.companionCondition.getRule();
    }

    public final boolean isLegal(Set<Card> cards, int minimumDeckSize) {
        return this.companionCondition.isLegal(cards, minimumDeckSize);
    }

    public final String getLegalRule() {
        return this.companionCondition.getRule();
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Card card = game.getState().getCompanion().getCard(this.getSourceId(), game);
        return card != null ? super.canActivate(playerId, game) : ActivatedAbility.ActivationStatus.getFalse();
    }
}

