/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import mage.MageObjectReference;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.ManaPool;
import mage.players.Player;
import mage.util.CardUtil;

class ConvokeEffect
extends OneShotEffect {
    private final ManaCost unpaid;

    public ConvokeEffect(ManaCost unpaid) {
        super(Outcome.Benefit);
        this.unpaid = unpaid;
        this.staticText = "Convoke (Your creatures can help cast this spell. Each creature you tap while casting this spell pays for {1} or one mana of that creature's color.)";
    }

    protected ConvokeEffect(ConvokeEffect effect) {
        super(effect);
        this.unpaid = effect.unpaid;
    }

    @Override
    public ConvokeEffect copy() {
        return new ConvokeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(source.getSourceId());
        if (controller != null && spell != null) {
            for (UUID creatureId : this.getTargetPointer().getTargets(game, source)) {
                String manaName;
                Permanent perm = game.getPermanent(creatureId);
                if (perm == null || perm.isTapped() || !perm.tap(source, game)) continue;
                ManaPool manaPool = controller.getManaPool();
                Choice chooseManaType = this.buildChoice(perm.getColor(game), this.unpaid.getMana());
                if (!chooseManaType.getChoices().isEmpty()) {
                    if (chooseManaType.getChoices().size() > 1) {
                        chooseManaType.getChoices().add("Colorless");
                        chooseManaType.setMessage("Choose mana color to reduce from " + perm.getName());
                        if (!controller.choose(Outcome.Benefit, chooseManaType, game)) {
                            return false;
                        }
                    } else {
                        chooseManaType.setChoice(chooseManaType.getChoices().iterator().next());
                    }
                    if (chooseManaType.getChoice().equals("Black")) {
                        manaPool.addMana(Mana.BlackMana(1), game, source);
                        manaPool.unlockManaType(ManaType.BLACK);
                    }
                    if (chooseManaType.getChoice().equals("Blue")) {
                        manaPool.addMana(Mana.BlueMana(1), game, source);
                        manaPool.unlockManaType(ManaType.BLUE);
                    }
                    if (chooseManaType.getChoice().equals("Green")) {
                        manaPool.addMana(Mana.GreenMana(1), game, source);
                        manaPool.unlockManaType(ManaType.GREEN);
                    }
                    if (chooseManaType.getChoice().equals("White")) {
                        manaPool.addMana(Mana.WhiteMana(1), game, source);
                        manaPool.unlockManaType(ManaType.WHITE);
                    }
                    if (chooseManaType.getChoice().equals("Red")) {
                        manaPool.addMana(Mana.RedMana(1), game, source);
                        manaPool.unlockManaType(ManaType.RED);
                    }
                    if (chooseManaType.getChoice().equals("Colorless")) {
                        manaPool.addMana(Mana.ColorlessMana(1), game, source);
                        manaPool.unlockManaType(ManaType.COLORLESS);
                    }
                    manaName = chooseManaType.getChoice().toLowerCase(Locale.ENGLISH);
                } else {
                    manaPool.addMana(Mana.ColorlessMana(1), game, source);
                    manaPool.unlockManaType(ManaType.COLORLESS);
                    manaName = "colorless";
                }
                HashSet<MageObjectReference> set = CardUtil.getSourceCostsTag(game, spell.getSpellAbility(), "convokingCreatures", new HashSet());
                set.add(new MageObjectReference(perm, game));
                spell.getSpellAbility().setCostsTag("convokingCreatures", set);
                game.informPlayers("Convoke: " + controller.getLogName() + " taps " + perm.getLogName() + " to pay one " + manaName + " mana");
                spell.setCurrentActivatingManaAbilitiesStep(ActivationManaAbilityStep.AFTER);
            }
            return true;
        }
        return false;
    }

    private Choice buildChoice(ObjectColor creatureColor, Mana mana) {
        ChoiceColor choice = new ChoiceColor();
        choice.getChoices().clear();
        if (creatureColor.isBlack() && mana.getBlack() > 0) {
            choice.getChoices().add("Black");
        }
        if (creatureColor.isBlue() && mana.getBlue() > 0) {
            choice.getChoices().add("Blue");
        }
        if (creatureColor.isGreen() && mana.getGreen() > 0) {
            choice.getChoices().add("Green");
        }
        if (creatureColor.isRed() && mana.getRed() > 0) {
            choice.getChoices().add("Red");
        }
        if (creatureColor.isWhite() && mana.getWhite() > 0) {
            choice.getChoices().add("White");
        }
        return choice;
    }
}

