/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CraftEffect
extends OneShotEffect {
    CraftEffect() {
        super(Outcome.Benefit);
    }

    private CraftEffect(CraftEffect effect) {
        super(effect);
    }

    @Override
    public CraftEffect copy() {
        return new CraftEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null || card.getZoneChangeCounter(game) != source.getStackMomentSourceZCC() + 1) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + source.getSourceId(), Boolean.TRUE);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

