/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.CumulativeUpkeepEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.counters.CounterType;
import mage.util.CardUtil;

public class CumulativeUpkeepAbility
extends BeginningOfUpkeepTriggeredAbility {
    private final Cost cumulativeCost;

    public CumulativeUpkeepAbility(Cost cumulativeCost) {
        super(new AddCountersSourceEffect(CounterType.AGE.createInstance()));
        this.addEffect(new CumulativeUpkeepEffect(cumulativeCost));
        this.cumulativeCost = cumulativeCost;
    }

    protected CumulativeUpkeepAbility(CumulativeUpkeepAbility ability) {
        super(ability);
        this.cumulativeCost = ability.cumulativeCost.copy();
    }

    @Override
    public CumulativeUpkeepAbility copy() {
        return new CumulativeUpkeepAbility(this);
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder("Cumulative upkeep");
        if (this.cumulativeCost instanceof ManaCost || this.cumulativeCost instanceof OrCost) {
            sb.append(' ');
            sb.append(this.cumulativeCost.getText());
        } else {
            sb.append("&mdash;");
            sb.append(CardUtil.getTextWithFirstCharUpperCase(this.cumulativeCost.getText()));
            sb.append(".");
        }
        return sb.toString();
    }
}

