/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.DelveSpecialAction;
import mage.abilities.mana.ManaOptions;
import mage.constants.AbilityType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

public class DelveAbility
extends SimpleStaticAbility
implements AlternateManaPaymentAbility {
    private static final DynamicValue cardsInGraveyard = new CardsInControllerGraveyardCount();
    private boolean useSourceExileZone;

    public DelveAbility(boolean useSourceExileZone) {
        super(Zone.ALL, null);
        this.setRuleAtTheTop(true);
        this.addHint(new ValueHint("Cards in your graveyard", cardsInGraveyard));
        this.useSourceExileZone = useSourceExileZone;
    }

    protected DelveAbility(DelveAbility ability) {
        super(ability);
    }

    @Override
    public DelveAbility copy() {
        return new DelveAbility(this);
    }

    @Override
    public String getRule() {
        return "Delve <i>(Each card you exile from your graveyard while casting this spell pays for {1}.)</i>";
    }

    @Override
    public ActivationManaAbilityStep useOnActivationManaAbilityStep() {
        return ActivationManaAbilityStep.AFTER;
    }

    @Override
    public void addSpecialAction(Ability source, Game game, ManaCost unpaid) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getGraveyard().isEmpty() && source.getAbilityType() == AbilityType.SPELL && unpaid.getMana().getGeneric() > 0) {
            DelveSpecialAction specialAction = new DelveSpecialAction(this);
            specialAction.setControllerId(source.getControllerId());
            specialAction.setSourceId(source.getSourceId());
            int unpaidAmount = unpaid.getMana().getGeneric();
            if (!controller.getManaPool().isAutoPayment() && unpaidAmount > 1) {
                unpaidAmount = 1;
            }
            specialAction.addCost(new ExileFromGraveCost(new TargetCardInYourGraveyard(0, Math.min(controller.getGraveyard().size(), unpaidAmount), new FilterCard("cards from your graveyard"), true)).withSourceExileZone(this.useSourceExileZone));
            if (specialAction.canActivate(source.getControllerId(), game).canActivate()) {
                game.getState().getSpecialActions().add(specialAction);
            }
        }
    }

    @Override
    public ManaOptions getManaOptions(Ability source, Game game, ManaCost unpaid) {
        ManaOptions options = new ManaOptions();
        Player controller = game.getPlayer(source.getControllerId());
        int graveCount = cardsInGraveyard.calculate(game, source, null);
        if (controller != null && graveCount > 0) {
            options.addMana(Mana.GenericMana(Math.min(unpaid.getMana().getGeneric(), graveCount)));
        }
        return options;
    }
}

