/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class DemonstrateEffect
extends OneShotEffect {
    DemonstrateEffect() {
        super(Outcome.Benefit);
    }

    private DemonstrateEffect(DemonstrateEffect effect) {
        super(effect);
    }

    @Override
    public DemonstrateEffect copy() {
        return new DemonstrateEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell == null) {
            return false;
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), true);
        TargetOpponent target = new TargetOpponent(true);
        controller.choose(this.outcome, target, source, game);
        if (game.getPlayer(target.getFirstTarget()) != null) {
            spell.createCopyOnStack(game, source, target.getFirstTarget(), true);
        }
        return true;
    }
}

