/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.SpellAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;

public class DisguiseAbility
extends SpellAbility {
    protected static final String ABILITY_KEYWORD = "Disguise";
    protected static final String REMINDER_TEXT = "You may cast this card face down for {3} as a 2/2 creature with ward {2}. Turn it face up any time for its disguise cost.";
    protected Costs<Cost> disguiseCosts;

    public DisguiseAbility(Card card, Cost disguiseCost) {
        this(card, disguiseCost, null);
    }

    public DisguiseAbility(Card card, Cost disguiseCost, CostAdjuster costAdjuster) {
        super(new GenericManaCost(3), card.getName());
        this.timing = TimingRule.SORCERY;
        this.disguiseCosts = new CostsImpl<Cost>();
        this.disguiseCosts.add(disguiseCost);
        this.setSpellAbilityCastMode(SpellAbilityCastMode.DISGUISE);
        this.setSpellAbilityType(SpellAbilityType.BASE_ALTERNATE);
        SimpleStaticAbility ability = new SimpleStaticAbility(new BecomesFaceDownCreatureEffect(this.disguiseCosts, null, Duration.WhileOnBattlefield, BecomesFaceDownCreatureEffect.FaceDownType.DISGUISED, costAdjuster));
        ability.setWorksFaceDown(true);
        ability.setRuleVisible(false);
        this.addSubAbility(ability);
    }

    protected DisguiseAbility(DisguiseAbility ability) {
        super(ability);
        this.disguiseCosts = ability.disguiseCosts;
    }

    @Override
    public DisguiseAbility copy() {
        return new DisguiseAbility(this);
    }

    public Costs<Cost> getFaceUpCosts() {
        return this.disguiseCosts;
    }

    @Override
    public String getRule() {
        boolean isMana = this.disguiseCosts.get(0) instanceof ManaCost;
        String costInfo = this.disguiseCosts.getText() + (isMana ? " " : ". ");
        return ABILITY_KEYWORD + (isMana ? " " : "&mdash;") + costInfo + " <i>(" + REMINDER_TEXT + ")</i>";
    }
}

