/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.keyword.EchoEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class EchoAbility
extends TriggeredAbilityImpl {
    protected UUID lastController;
    protected boolean echoPaid;
    protected Costs<Cost> echoCosts = new CostsImpl<Cost>();
    private boolean manaEcho = true;
    private DynamicValue amount;
    private String rule;

    public EchoAbility(String manaString) {
        super(Zone.BATTLEFIELD, new EchoEffect(new ManaCostsImpl(manaString)), false);
        this.echoPaid = false;
        this.echoCosts.add(new ManaCostsImpl(manaString));
        this.lastController = null;
        this.rule = null;
    }

    public EchoAbility(DynamicValue amount, String rule) {
        super(Zone.BATTLEFIELD, new EchoEffect(amount), false);
        this.amount = amount;
        this.echoPaid = false;
        this.echoCosts.add(this.getCosts());
        this.lastController = null;
        this.manaEcho = true;
        this.rule = rule;
    }

    public EchoAbility(Cost echoCost) {
        super(Zone.BATTLEFIELD, new EchoEffect(echoCost), false);
        this.echoPaid = false;
        this.echoCosts.add(echoCost);
        this.manaEcho = false;
        this.lastController = null;
        this.rule = null;
    }

    protected EchoAbility(EchoAbility ability) {
        super(ability);
        this.echoPaid = ability.echoPaid;
        this.echoCosts = ability.echoCosts.copy();
        this.manaEcho = ability.manaEcho;
        this.lastController = ability.lastController;
        this.amount = ability.amount;
        this.rule = ability.rule;
    }

    @Override
    public EchoAbility copy() {
        return new EchoAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(this.getSourceId())) {
            this.echoPaid = false;
        }
        if (event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE) {
            if (this.lastController != null && !this.lastController.equals(this.controllerId)) {
                this.echoPaid = false;
            }
            this.lastController = this.getControllerId();
            if (event.getPlayerId().equals(this.controllerId) && this.lastController.equals(this.controllerId) && !this.echoPaid) {
                this.echoPaid = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder();
        if (this.rule != null) {
            sb.append(this.rule);
        } else {
            sb = new StringBuilder("Echo");
            if (this.manaEcho) {
                sb.append(' ');
            } else {
                sb.append("&mdash;");
            }
            if (this.echoCosts != null) {
                sb.append(this.echoCosts.getText());
            }
            if (!this.manaEcho) {
                sb.append('.');
            }
        }
        sb.append(" <i>(At the beginning of your upkeep, if this came under your control since the beginning of your last upkeep, sacrifice it unless you pay its echo cost.)</i>");
        return sb.toString();
    }
}

