/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.stream.Collectors;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileSourceFromGraveCost;
import mage.abilities.keyword.EmbalmEffect;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.TimingRule;
import mage.constants.Zone;

public class EmbalmAbility
extends ActivatedAbilityImpl {
    private final String rule;

    public EmbalmAbility(Cost cost, Card card) {
        super(Zone.GRAVEYARD, new EmbalmEffect(), cost);
        this.addCost(new ExileSourceFromGraveCost());
        this.rule = this.setRule(cost, card);
        this.timing = TimingRule.SORCERY;
    }

    protected EmbalmAbility(EmbalmAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public EmbalmAbility copy() {
        return new EmbalmAbility(this);
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    private String setRule(Cost cost, Card card) {
        return "Embalm " + cost.getText() + " <i>(" + cost.getText() + ", Exile this card from your graveyard: Create a token that's a copy of it, except it's a white Zombie " + card.getSubtype().stream().map(SubType::getDescription).map(s -> s + ' ').collect(Collectors.joining()) + "with no mana cost. Embalm only as a sorcery.)</i>";
    }
}

